IF EXISTS( SELECT 1 FROM SYS.VIEWS WHERE  OBJECT_ID = OBJECT_ID(N'[DBO].[V_CTB_APURA_ICMS_AJUSTES_CFOP]') )
DROP VIEW [DBO].[V_CTB_APURA_ICMS_AJUSTES_CFOP];
GO

CREATE VIEW [DBO].[V_CTB_APURA_ICMS_AJUSTES_CFOP]
WITH ENCRYPTION
AS

--ENTRADAS >> TIPO = 02 - Ajuste de Debito Outorgado"
--REGRA: CFOP CONFIGURADO; STS_NF = 0;  % ICMS > 0;  % ICMS > % OUTORGADO; VLR_ICMS_IT > 0 

SELECT  
   1 as CONSULTA,  
   EST_NF_ENT.CD_EMP,
   EST_NF_ENT.CD_FILIAL,
   EST_NF_ENT.CD_NF AS CD_DOC,
   0 AS TIPO_DOC,
   EST_NF_ENT.DT_ENT AS DT_DOC,
   NR_NF AS NR_DOC,
   0 AS CD_CX,
   DS_MOV_OP  AS NAT_MOV,
   TBL_ICMS_AJUSTES.CD_CTR AS CD_CTR_AJUSTE,
   TBL_ICMS_AJUSTES.COD_AJUSTE,
   TBL_ICMS_AJUSTES.TIPO AS TIPO_AJUSTE_ICMS,
   'Ajuste de Dbito Outorgado' AS TIPO_AJUSTE_CFOP,
   EST_NF_ENT_IT.CD_PROD,
   EST_NF_ENT_IT.SEQ_ITEM AS CD_IT,
   EST_PROD.DS_PROD,
   CD_NT_OP_FC,
   CD_TRIB_FC,
   EST_NF_ENT_IT.VLR_BASE_ICMS,
   EST_NF_ENT_IT.VLR_ICMS_IT,
   EST_NF_ENT_IT.ALIQ_ICMS,
   GLB_NT_OP.CD_NT_OP,
   GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG, 
   DS_AJUSTE ,
   ROUND(EST_NF_ENT_IT.VLR_BASE_ICMS * (EST_NF_ENT_IT.ALIQ_ICMS - GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG ) / 100 ,2) AS VLR_AJUSTE,
   ISNULL(CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_CTR, 0) AS CD_AJUSTE_GRAVADO,
   ISNULL(CTB_APURA_ICMS_AJUSTES.VALOR, 0) AS VLR_AJUSTE_GRAVADO,
   2 AS CD_TIPO_AJUSTE_CFOP 
     
   FROM EST_NF_ENT_IT INNER JOIN
       DBO.EST_NF_ENT ON  DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
   	AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
   	AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
   	AND DBO.EST_NF_ENT.DT_ENT = DBO.EST_NF_ENT_IT.DT_ENT
 
	INNER JOIN PRC_FILIAL ON     
   EST_NF_ENT.CD_EMP =  PRC_fILIAL.CD_EMP 
   AND EST_NF_ENT.CD_FILIAL =  PRC_fILIAL.CD_FILIAL
   INNER JOIN GLB_CID ON GLB_CID.CD_CID = PRC_FILIAL.CD_CID

   INNER JOIN DBO.EST_TRIB ON DBO.EST_NF_ENT_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
   INNER JOIN EST_PROD ON EST_PROD.CD_EMP =  EST_NF_ENT_IT.CD_EMP
   AND EST_PROD.CD_PROD =  EST_NF_ENT_IT.CD_PROD
   INNER JOIN DBO.GLB_NT_OP ON DBO.EST_NF_ENT_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
   INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
   OUTER APPLY UFD_GLB_PESSOA(EST_NF_ENT.CD_FORN, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA	  
   INNER JOIN GLB_NT_OP_ICMS_AJUSTES ON 
   GLB_NT_OP.CD_NT_OP = GLB_NT_OP_ICMS_AJUSTES.CD_NT_OP
   INNER JOIN TBL_ICMS_AJUSTES ON 
   GLB_NT_OP_ICMS_AJUSTES.CD_CTR_AJUSTE = TBL_ICMS_AJUSTES.CD_CTR
   
    LEFT JOIN CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT ON  
    CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_IT.CD_EMP  
    AND CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL  
    AND CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_NF = EST_NF_ENT_IT.CD_NF  
    AND CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_IT.CD_PROD
	
	LEFT JOIN CTB_APURA_ICMS_AJUSTES ON  
	CTB_APURA_ICMS_AJUSTES.CD_EMP = CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_EMP
	AND CTB_APURA_ICMS_AJUSTES.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_FILIAL
	AND CTB_APURA_ICMS_AJUSTES.CD_CTR = CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_CTR
	     
   WHERE EST_NF_ENT_IT.ALIQ_ICMS  > 0 
   AND EST_NF_ENT_IT.ALIQ_ICMS > GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG
   AND GLB_NT_OP_ICMS_AJUSTES.TIPO = 2
   AND EST_NF_ENT_IT.VLR_ICMS_IT > 0
   AND EST_NF_ENT.DT_ENT > = GLB_NT_OP_ICMS_AJUSTES.DATA_INICIO
   AND GLB_CID.UF = LEFT(TBL_ICMS_AJUSTES.COD_AJUSTE,2)
   AND STS_NF = 0
   AND GLB_MOV_OP.TP_MOV = 0
 
   
   UNION ALL 

--SADAS NFE   >> TIPO = 01 - Ajuste de Crdito Outorgado"
--REGRA: CFOP CONFIGURADO; STS_NF = 0;  % ICMS > 0;  % ICMS > % OUTORGADO; VLR_ICMS_IT > 0 

  SELECT 
         2 as CONSULTA,  
         EST_NF_SAI.CD_EMP,
         EST_NF_SAI.CD_FILIAL,
         EST_NF_SAI.CD_NF AS CD_DOC, 
		 1 AS TIPO_DOC,
         EST_NF_SAI.DT_EMI_NF AS DT_DOC,
         NF_NF AS NR_DOC,
		 0 AS CD_CX, 
         DS_MOV_OP AS NAT_MOV,
		 TBL_ICMS_AJUSTES.CD_CTR AS CD_CTR_AJUSTE,
         TBL_ICMS_AJUSTES.COD_AJUSTE,
         TBL_ICMS_AJUSTES.TIPO AS TIPO_AJUSTE_ICMS,
         'Ajuste de Crdito Outorgado' AS TIPO_AJUSTE_CFOP,
         EST_NF_SAI_IT.CD_PROD,
		 EST_NF_SAI_IT.CD_IT ,
         EST_PROD.DS_PROD,
         CD_NT_OP_FC,
         CD_TRIB_FC,
         EST_NF_SAI_IT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
         EST_NF_SAI_IT.VLR_ICMS_IT,
         EST_NF_SAI_IT.ALIQ_ICMS,
         GLB_NT_OP.CD_NT_OP,
         GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG,
         DS_AJUSTE,
  	   ROUND(EST_NF_SAI_IT.VLR_BASE_ICMS_IT * (EST_NF_SAI_IT.ALIQ_ICMS - GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG) / 100, 2) AS VLR_AJUSTE,
  	   ISNULL(CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_CTR, 0) AS CD_AJUSTE_GRAVADO,
	   ISNULL(CTB_APURA_ICMS_AJUSTES.VALOR, 0) AS VLR_AJUSTE_GRAVADO,
	   1 AS CD_TIPO_AJUSTE_CFOP 
  
    FROM EST_NF_SAI_IT
  INNER JOIN DBO.EST_NF_SAI ON DBO.EST_NF_SAI.CD_EMP = DBO.EST_NF_SAI_IT.CD_EMP
  AND DBO.EST_NF_SAI.CD_FILIAL = DBO.EST_NF_SAI_IT.CD_FILIAL
  AND DBO.EST_NF_SAI.CD_NF = DBO.EST_NF_SAI_IT.CD_NF
  AND DBO.EST_NF_SAI.DT_EMI_NF = DBO.EST_NF_SAI_IT.DT_EMI_NF

  INNER JOIN PRC_FILIAL ON     
   EST_NF_SAI.CD_EMP =  PRC_fILIAL.CD_EMP 
   AND EST_NF_SAI.CD_FILIAL =  PRC_fILIAL.CD_FILIAL
   INNER JOIN GLB_CID ON GLB_CID.CD_CID = PRC_FILIAL.CD_CID

  INNER JOIN EST_TRIB ON DBO.EST_NF_SAI_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
  INNER JOIN EST_PROD ON EST_PROD.CD_EMP = EST_NF_SAI_IT.CD_EMP
  AND EST_PROD.CD_PROD = EST_NF_SAI_IT.CD_PROD
  INNER JOIN GLB_NT_OP ON DBO.EST_NF_SAI_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
  INNER JOIN GLB_MOV_OP ON DBO.EST_NF_SAI.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP OUTER APPLY UFD_GLB_PESSOA(EST_NF_SAI.CD_CLI, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA
  inner JOIN GLB_NT_OP_ICMS_AJUSTES ON GLB_NT_OP.CD_NT_OP = GLB_NT_OP_ICMS_AJUSTES.CD_NT_OP
  inner JOIN TBL_ICMS_AJUSTES ON GLB_NT_OP_ICMS_AJUSTES.CD_CTR_AJUSTE = TBL_ICMS_AJUSTES.CD_CTR
 
 LEFT JOIN CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT ON CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_EMP = EST_NF_SAI_IT.CD_EMP
  AND CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
  AND CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_NF = EST_NF_SAI_IT.CD_NF
  AND CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_PROD = EST_NF_SAI_IT.CD_PROD

  LEFT JOIN CTB_APURA_ICMS_AJUSTES ON  
	CTB_APURA_ICMS_AJUSTES.CD_EMP = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_EMP
	AND CTB_APURA_ICMS_AJUSTES.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_FILIAL
	AND CTB_APURA_ICMS_AJUSTES.CD_CTR = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_CTR
 
 WHERE EST_NF_SAI_IT.ALIQ_ICMS > 0
    AND EST_NF_SAI_IT.VLR_ICMS_IT > 0 
    AND EST_NF_SAI_IT.ALIQ_ICMS > GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG
    AND GLB_NT_OP_ICMS_AJUSTES.TIPO = 1
	AND EST_NF_SAI.DT_EMI_NF > = GLB_NT_OP_ICMS_AJUSTES.DATA_INICIO
	AND GLB_CID.UF = LEFT(TBL_ICMS_AJUSTES.COD_AJUSTE,2)
    AND EST_NF_SAI.STS_NF = 0
	AND TP_MOV = 0
	
   
UNION ALL
--SADAS NFCE >> TIPO = 01 - Ajuste de Crdito Outorgado"
--REGRA: CFOP CONFIGURADO; STS_VD = 0; ST_IT = 1;  % ICMS > 0;  % ICMS > % OUTORGADO; VLR_ICMS > 0 

  SELECT 
         3 as CONSULTA, 
         PDV_VD.CD_EMP, 
         PDV_VD.CD_FILIAL,
         PDV_VD.CD_VD AS CD_DOC, 
		 2 AS TIPO_DOC,
         PDV_VD.DT_VD AS DT_DOC,
         PDV_VD.NR_ECF  AS NR_DOC,
  	     PDV_VD.CD_CX ,
         'VENDA NFCE' AS NAT_MOV,
		 TBL_ICMS_AJUSTES.CD_CTR AS CD_CTR_AJUSTE,
         TBL_ICMS_AJUSTES.COD_AJUSTE,
         TBL_ICMS_AJUSTES.TIPO AS TIPO_AJUSTE_ICMS,
        'Ajuste de Crdito Outorgado' AS TIPO_AJUSTE_CFOP,
         PDV_VD_IT.CD_PROD,
		 PDV_VD_IT.CD_IT ,
         EST_PROD.DS_PROD,
         GLB_NT_OP.CD_NT_OP_FC,
         CD_TRIB_FC,
         PDV_VD_IT.VLR_BASE_CALC AS VLR_BASE_ICMS,
         PDV_VD_IT.VLR_ICMS AS VLR_ICMS_IT,
         PDV_VD_IT.TX_ICMS_IT AS ALIQ_ICMS,
         GLB_NT_OP.CD_NT_OP,
         GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG,
         DS_AJUSTE,
  
	  ROUND(PDV_VD_IT.vlr_base_calc * (PDV_VD_IT.TX_ICMS_IT - GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG ) / 100, 2) AS VLR_AJUSTE,
  	 
	 ISNULL(CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_CTR, 0) AS CD_AJUSTE_GRAVADO,
	 ISNULL(CTB_APURA_ICMS_AJUSTES.VALOR, 0) AS VLR_AJUSTE_GRAVADO,
	   1 AS CD_TIPO_AJUSTE_CFOP 
   
	FROM PDV_VD_IT INNER JOIN DBO.PDV_VD ON 
      DBO.PDV_VD.CD_EMP = DBO.PDV_VD_IT.CD_EMP
      AND DBO.PDV_VD.CD_FILIAL = DBO.PDV_VD_IT.CD_FILIAL
      AND DBO.PDV_VD.CD_vd = DBO.PDV_VD_IT.CD_VD
  INNER JOIN EST_PROD ON EST_PROD.CD_EMP = PDV_VD_IT.CD_EMP
  AND EST_PROD.CD_PROD = PDV_VD_IT.CD_PROD

  INNER JOIN PRC_FILIAL ON     
   PDV_VD.CD_EMP =  PRC_fILIAL.CD_EMP 
   AND PDV_VD.CD_FILIAL =  PRC_fILIAL.CD_FILIAL
   INNER JOIN GLB_CID ON GLB_CID.CD_CID = PRC_FILIAL.CD_CID
  
  INNER JOIN GLB_NT_OP ON REPLACE(GLB_NT_OP.CD_NT_OP_FC, '.', '') = DBO.PDV_VD_IT.CFOP
   
  OUTER APPLY UFD_GLB_PESSOA(PDV_VD.CD_CLI, 0) V_GLB_PESSOA
  inner JOIN GLB_NT_OP_ICMS_AJUSTES ON GLB_NT_OP.CD_NT_OP = GLB_NT_OP_ICMS_AJUSTES.CD_NT_OP
  inner JOIN TBL_ICMS_AJUSTES ON GLB_NT_OP_ICMS_AJUSTES.CD_CTR_AJUSTE = TBL_ICMS_AJUSTES.CD_CTR
  LEFT JOIN CTB_APURA_ICMS_AJUSTES_PDV_VD_IT ON CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_EMP = PDV_VD_IT.CD_EMP
  AND CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_FILIAL = PDV_VD_IT.CD_FILIAL
  AND CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_VD = PDV_VD_IT.CD_VD
  AND CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_PROD = PDV_VD_IT.CD_PROD
  AND CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_IT = PDV_VD_IT.CD_IT

   LEFT JOIN CTB_APURA_ICMS_AJUSTES ON  
	CTB_APURA_ICMS_AJUSTES.CD_EMP = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_EMP
	AND CTB_APURA_ICMS_AJUSTES.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_FILIAL
	AND CTB_APURA_ICMS_AJUSTES.CD_CTR = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_CTR
   
  WHERE -- PDV_VD.DT_VD > '20241001' AND  PDV_VD.CD_FILIAL = 5  AND 
    PDV_VD_IT.TX_ICMS_IT > 0
    AND  PDV_VD_IT.VLR_ICMS > 0 
    AND  PDV_VD_IT.TX_ICMS_IT > GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG 
    AND GLB_NT_OP_ICMS_AJUSTES.TIPO = 1
	AND PDV_VD.DT_VD > = GLB_NT_OP_ICMS_AJUSTES.DATA_INICIO
	AND GLB_CID.UF = LEFT(TBL_ICMS_AJUSTES.COD_AJUSTE,2)
    AND PDV_VD.ST_VD =  0 
    AND PDV_VD_IT.ST_IT = 1
 
 UNION ALL
  
  --===================== DEVOLUES==================================
-- Essa devoluo no precisa fazer vinculo com CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT
--SADAS NFE DEVOLUO >> TIPO = 03 - Estorno ICMS Ref. Devoluo ICMS ST"
--REGRA: CFOP CONFIGURADO; STS_NF = 0;  % ICMS > 0; VLR_ICMS_IT > 0 
 
  SELECT 
        4 as CONSULTA,  
        EST_NF_SAI.CD_EMP,
        EST_NF_SAI.CD_FILIAL,
        EST_NF_SAI.CD_NF AS CD_DOC, 
		1 AS TIPO_DOC,
        EST_NF_SAI.DT_EMI_NF AS DT_DOC,
        NF_NF AS NR_DOC,
		0 AS CD_CX,
        DS_MOV_OP AS NAT_MOV,
		TBL_ICMS_AJUSTES.CD_CTR AS CD_CTR_AJUSTE,
        TBL_ICMS_AJUSTES.COD_AJUSTE,
        TBL_ICMS_AJUSTES.TIPO AS TIPO_AJUSTE_ICMS,
        'Estorno ICMS Ref. Devoluo ICMS ST' AS TIPO_AJUSTE_CFOP,
        EST_NF_SAI_IT.CD_PROD,
		EST_NF_SAI_IT.CD_IT ,
        EST_PROD.DS_PROD,
        CD_NT_OP_FC,
        CD_TRIB_FC,
        EST_NF_SAI_IT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
        EST_NF_SAI_IT.VLR_ICMS_IT,
        EST_NF_SAI_IT.ALIQ_ICMS,
        GLB_NT_OP.CD_NT_OP,
        GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG,
        DS_AJUSTE,
 	   --ROUND(EST_NF_SAI_IT.VLR_BASE_ICMS_IT * (EST_NF_SAI_IT.ALIQ_ICMS - GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG) / 100, 2) AS VLR_AJUSTE,
 	   EST_NF_SAI_IT.VLR_ICMS_IT  AS VLR_AJUSTE ,
	   ISNULL(CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_CTR, 0) AS CD_AJUSTE_GRAVADO,
	   ISNULL(CTB_APURA_ICMS_AJUSTES.VALOR, 0) AS VLR_AJUSTE_GRAVADO,
	   3 AS CD_TIPO_AJUSTE_CFOP 
     
    FROM EST_NF_SAI INNER JOIN  EST_NF_ENT_NF_SAI ON 
      EST_NF_ENT_NF_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND  
      EST_NF_ENT_NF_SAI.CD_FILIAL = EST_NF_SAI.CD_FILIAL AND 
      EST_NF_ENT_NF_SAI.CD_NF_SAI = EST_NF_SAI.CD_NF  
 
 	 INNER JOIN EST_NF_SAI_IT ON DBO.EST_NF_SAI.CD_EMP = DBO.EST_NF_SAI_IT.CD_EMP
	 AND DBO.EST_NF_SAI.CD_FILIAL = DBO.EST_NF_SAI_IT.CD_FILIAL
	 AND DBO.EST_NF_SAI.CD_NF = DBO.EST_NF_SAI_IT.CD_NF
	 AND DBO.EST_NF_SAI.DT_EMI_NF = DBO.EST_NF_SAI_IT.DT_EMI_NF

	 INNER JOIN PRC_FILIAL ON     
		EST_NF_SAI.CD_EMP =  PRC_fILIAL.CD_EMP 
		AND EST_NF_SAI.CD_FILIAL =  PRC_fILIAL.CD_FILIAL
		INNER JOIN GLB_CID ON GLB_CID.CD_CID = PRC_FILIAL.CD_CID
  
	 INNER JOIN EST_TRIB ON DBO.EST_NF_SAI_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
	 INNER JOIN EST_PROD ON EST_PROD.CD_EMP = EST_NF_SAI_IT.CD_EMP
	 AND EST_PROD.CD_PROD = EST_NF_SAI_IT.CD_PROD
	 INNER JOIN GLB_NT_OP ON DBO.EST_NF_SAI_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
	 INNER JOIN GLB_MOV_OP ON DBO.EST_NF_SAI.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP OUTER APPLY UFD_GLB_PESSOA(EST_NF_SAI.CD_CLI, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA
	 inner JOIN GLB_NT_OP_ICMS_AJUSTES ON GLB_NT_OP.CD_NT_OP = GLB_NT_OP_ICMS_AJUSTES.CD_NT_OP
	 inner JOIN TBL_ICMS_AJUSTES ON GLB_NT_OP_ICMS_AJUSTES.CD_CTR_AJUSTE = TBL_ICMS_AJUSTES.CD_CTR
  
	LEFT JOIN CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT ON CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_EMP = EST_NF_SAI_IT.CD_EMP
	  AND CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
	  AND CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_NF = EST_NF_SAI_IT.CD_NF
	  AND CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_PROD = EST_NF_SAI_IT.CD_PROD

     LEFT JOIN CTB_APURA_ICMS_AJUSTES ON  
	CTB_APURA_ICMS_AJUSTES.CD_EMP = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_EMP
	AND CTB_APURA_ICMS_AJUSTES.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_FILIAL
	AND CTB_APURA_ICMS_AJUSTES.CD_CTR = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_CTR
   
	 WHERE   
	   EST_NF_SAI_IT.ALIQ_ICMS > 0
	   AND EST_NF_SAI_IT.VLR_ICMS_IT > 0 
	   AND GLB_NT_OP_ICMS_AJUSTES.TIPO = 3
	   --AND EST_NF_SAI_IT.DT_EMI_NF > = GLB_NT_OP_ICMS_AJUSTES.DATA_INICIO
	   AND GLB_CID.UF = LEFT(TBL_ICMS_AJUSTES.COD_AJUSTE,2)
	   AND EST_NF_SAI.STS_NF =  0
	   AND TP_MOV = 11


UNION ALL 
 
 --SADAS NFE DEVOLUO >> Estorno do TIPO = 02 - Ajuste de Debito Outorgado "
 -- Que tenha registro na CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT
 --Dever gerar um registro de ajuste com  o TIPO = 01 - Ajuste de Crdito Outorgado
 --REGRA: CFOP CONFIGURADO; STS_NF = 0;  % ICMS > 0; VLR_ICMS_IT > 0  
  
       SELECT  
	    5 as CONSULTA,  
	    EST_NF_SAI.CD_EMP,
        EST_NF_SAI.CD_FILIAL,
        EST_NF_SAI.CD_NF AS CD_DOC, 
		1 AS TIPO_DOC,
        EST_NF_SAI.DT_EMI_NF AS DT_DOC,
        NF_NF AS NR_DOC,
		0 AS CD_CX,
        DS_MOV_OP AS NAT_MOV,
		TBL_ICMS_AJUSTES.CD_CTR AS CD_CTR_AJUSTE,
        TBL_ICMS_AJUSTES.COD_AJUSTE,
        TBL_ICMS_AJUSTES.TIPO AS TIPO_AJUSTE_ICMS,
        'Ajuste de Crdito Outorgado' AS TIPO_AJUSTE_CFOP,
        EST_NF_SAI_IT.CD_PROD,
		EST_NF_SAI_IT.CD_IT ,
        EST_PROD.DS_PROD,
        CD_NT_OP_FC,
        CD_TRIB_FC,
        EST_NF_SAI_IT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
        EST_NF_SAI_IT.VLR_ICMS_IT,
        EST_NF_SAI_IT.ALIQ_ICMS,
        GLB_NT_OP.CD_NT_OP,
        GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG,
        DS_AJUSTE,
 	    
		--VALOR_AJUSTE NA ENTRADA/QT_IT NA ENTRADA = VALOR UNITRIO,  MULTIPLICAR PELA QUANTIDADE VENDIDA
		-- ENTRADA PRODUTO NF: 123  1  QTDE 2 UNIDADES  50,00   25,00 UNIDADE
		-- DEVOLVENDO UMA UNIDADE  SAIDA DEVO  PRODUTO 1  1 UNIDADE 
		--(50,00 / 2 ) * 1 
		
		--(CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.VLR_AJUSTE /EST_NF_ENT_IT.QT_IT )  * EST_NF_SAI_IT.QT_IT   AS VLR_AJUSTE ,
		
		EST_NF_SAI_IT.VLR_BASE_ICMS_IT * (EST_NF_SAI_IT.ALIQ_ICMS - GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG )/100  AS VLR_AJUSTE, 

		ISNULL(CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_CTR,0) AS CD_AJUSTE_GRAVADO,
		ISNULL(CTB_APURA_ICMS_AJUSTES.VALOR, 0) AS VLR_AJUSTE_GRAVADO,
	    1 AS CD_TIPO_AJUSTE_CFOP 
     
 FROM EST_NF_SAI INNER JOIN  EST_NF_ENT_NF_SAI ON 
      EST_NF_ENT_NF_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND  
      EST_NF_ENT_NF_SAI.CD_FILIAL = EST_NF_SAI.CD_FILIAL AND 
      EST_NF_ENT_NF_SAI.CD_NF_SAI = EST_NF_SAI.CD_NF 
	  
	INNER JOIN EST_NF_SAI_IT ON DBO.EST_NF_SAI.CD_EMP = DBO.EST_NF_SAI_IT.CD_EMP
	 AND DBO.EST_NF_SAI.CD_FILIAL = DBO.EST_NF_SAI_IT.CD_FILIAL
	 AND DBO.EST_NF_SAI.CD_NF = DBO.EST_NF_SAI_IT.CD_NF
	 AND DBO.EST_NF_SAI.DT_EMI_NF = DBO.EST_NF_SAI_IT.DT_EMI_NF

	 INNER JOIN EST_NF_ENT  ON 
	      DBO.EST_NF_ENT_NF_SAI.CD_EMP = DBO.EST_NF_ENT.CD_EMP
	  AND DBO.EST_NF_ENT_NF_SAI.CD_FILIAL = DBO.EST_NF_ENT.CD_FILIAL
	 AND  DBO.EST_NF_ENT_NF_SAI.CD_NF_ENT = DBO.EST_NF_ENT.CD_NF

	 INNER JOIN EST_NF_ENT_IT ON 
	 DBO.EST_NF_ENT_IT.CD_EMP = DBO.EST_NF_ENT.CD_EMP
	  AND DBO.EST_NF_ENT_IT.CD_FILIAL = DBO.EST_NF_ENT.CD_FILIAL
	 AND  DBO.EST_NF_ENT_IT.CD_NF = DBO.EST_NF_ENT.CD_NF
     AND  DBO.EST_NF_ENT_IT.CD_PROD = DBO.EST_NF_SAI_IT.CD_PROD

	 LEFT JOIN  CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT ON 
	 CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_EMP = EST_NF_SAI_IT.CD_EMP 
	 AND CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
	 AND CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_NF = EST_NF_ENT_IT.CD_NF
	 AND CTB_APURA_ICMS_AJUSTES_EST_NF_ENT_IT.CD_PROD = EST_NF_SAI_IT.CD_PROD
 
	INNER JOIN PRC_FILIAL ON     
		EST_NF_SAI.CD_EMP =  PRC_fILIAL.CD_EMP 
		AND EST_NF_SAI.CD_FILIAL =  PRC_fILIAL.CD_FILIAL
	INNER JOIN GLB_CID ON GLB_CID.CD_CID = PRC_FILIAL.CD_CID
	INNER JOIN EST_TRIB ON DBO.EST_NF_SAI_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
	INNER JOIN EST_PROD ON EST_PROD.CD_EMP = EST_NF_SAI_IT.CD_EMP
	AND EST_PROD.CD_PROD = EST_NF_SAI_IT.CD_PROD
	
	INNER JOIN GLB_NT_OP ON DBO.EST_NF_SAI_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
	INNER JOIN GLB_MOV_OP ON DBO.EST_NF_SAI.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP OUTER APPLY UFD_GLB_PESSOA(EST_NF_SAI.CD_CLI, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA
    inner JOIN GLB_NT_OP_ICMS_AJUSTES ON GLB_NT_OP.CD_NT_OP = GLB_NT_OP_ICMS_AJUSTES.CD_NT_OP
    inner JOIN TBL_ICMS_AJUSTES ON GLB_NT_OP_ICMS_AJUSTES.CD_CTR_AJUSTE = TBL_ICMS_AJUSTES.CD_CTR

	LEFT JOIN CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT ON 
	EST_NF_SAI_IT.CD_EMP = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_EMP 
	AND EST_NF_SAI_IT.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_FILIAL 
	AND EST_NF_SAI_IT.CD_NF = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_NF
	AND EST_NF_SAI_IT.CD_PROD = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_PROD

	LEFT JOIN CTB_APURA_ICMS_AJUSTES ON  
	CTB_APURA_ICMS_AJUSTES.CD_EMP = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_EMP
	AND CTB_APURA_ICMS_AJUSTES.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_FILIAL
	AND CTB_APURA_ICMS_AJUSTES.CD_CTR = CTB_APURA_ICMS_AJUSTES_EST_NF_SAI_IT.CD_CTR

	WHERE EST_NF_SAI_IT.ALIQ_ICMS > 0 
	     AND EST_NF_SAI_IT.VLR_ICMS_IT > 0
	     AND GLB_NT_OP_ICMS_AJUSTES.TIPO = 1
	     --AND EST_NF_SAI.DT_EMI_NF > = GLB_NT_OP_ICMS_AJUSTES.DATA_INICIO
		 AND GLB_CID.UF = LEFT(TBL_ICMS_AJUSTES.COD_AJUSTE,2)
	     AND EST_NF_SAI.STS_NF =  0
		 AND GLB_MOV_OP.TP_MOV =  11
		 

 UNION ALL 
 
--ENTRADAS DEVOLUO VENDAS >> TIPO = 0     Outorgado"
--REGRA: CFOP CONFIGURADO; STS_NF = 0;  % ICMS > 0;  % ICMS > % OUTORGADO; VLR_ICMS_IT > 0 

SELECT  
   6 as CONSULTA,  
   EST_NF_ENT.CD_EMP,
   EST_NF_ENT.CD_FILIAL,
   EST_NF_ENT.CD_NF AS CD_DOC,
   0 AS TIPO_DOC,
   EST_NF_ENT.DT_ENT AS DT_DOC,
   NR_NF AS NR_DOC,
   0 AS CD_CX,
   DS_MOV_OP  AS NAT_MOV,
   TBL_ICMS_AJUSTES.CD_CTR AS CD_CTR_AJUSTE,
   TBL_ICMS_AJUSTES.COD_AJUSTE,
   TBL_ICMS_AJUSTES.TIPO AS TIPO_AJUSTE_ICMS,
   'Ajuste de Dbito Outorgado' AS TIPO_AJUSTE_CFOP,
   EST_NF_ENT_IT.CD_PROD,
   EST_NF_ENT_IT.SEQ_ITEM AS CD_IT,
   EST_PROD.DS_PROD,
   GLB_NT_OP.CD_NT_OP_FC,
   EST_TRIB.CD_TRIB_FC,
   EST_NF_ENT_IT.VLR_BASE_ICMS,
   EST_NF_ENT_IT.VLR_ICMS_IT,
   EST_NF_ENT_IT.ALIQ_ICMS,
   GLB_NT_OP.CD_NT_OP,
   GLB_NT_OP_ICMS_AJUSTES.PERC_ALIQ_OUTORG, 
   DS_AJUSTE ,
   --VALOR_AJUSTE NA ENTRADA/QT_IT NA ENTRADA = VALOR UNITRIO,  MULTIPLICAR PELA QUANTIDADE VENDIDA
	 	
   (CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.VLR_AJUSTE / PDV_VD_IT.QT_IT) * EST_NF_ENT_IT.QT_IT  AS VLR_AJUSTE,
    ISNULL(CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_CTR,0) AS CD_AJUSTE_GRAVADO,
	ISNULL(CTB_APURA_ICMS_AJUSTES.VALOR, 0) AS VLR_AJUSTE_GRAVADO,
   2 AS CD_TIPO_AJUSTE_CFOP 
     
   FROM EST_NF_ENT_IT INNER JOIN
    DBO.EST_NF_ENT ON  DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
   	AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
   	AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
   	AND DBO.EST_NF_ENT.DT_ENT = DBO.EST_NF_ENT_IT.DT_ENT

   INNER JOIN DBO.EST_TRIB ON DBO.EST_NF_ENT_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
   INNER JOIN EST_PROD ON EST_PROD.CD_EMP =  EST_NF_ENT_IT.CD_EMP
   AND EST_PROD.CD_PROD =  EST_NF_ENT_IT.CD_PROD
   INNER JOIN DBO.GLB_NT_OP ON DBO.EST_NF_ENT_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
   INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
   OUTER APPLY UFD_GLB_PESSOA(EST_NF_ENT.CD_FORN, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA	  

	INNER  JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT ON 
	 DBO.PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
   	AND DBO.PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
   	AND DBO.PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
   	AND DBO.PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_PROD = DBO.EST_NF_ENT_IT.CD_PROD
	AND DBO.PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_IT = DBO.EST_NF_ENT_IT.SEQ_ITEM

	INNER JOIN  PDV_VD_DEV_EST_PROD_IMP ON 

     PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_EMP AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_FILIAL AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_VD AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_IMP = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_IMP AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_PROD = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_PROD AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_IT = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_IT

	 INNER  JOIN PDV_VD_IT ON
	 PDV_VD_IT.CD_EMP = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_EMP AND 
     PDV_VD_IT.CD_FILIAL = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_FILIAL AND 
     PDV_VD_IT.CD_VD = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_VD AND 
     PDV_VD_IT.CD_PROD = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_PROD AND 
     PDV_VD_IT.CD_IT = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_IT

	 INNER JOIN GLB_NT_OP_ICMS_AJUSTES ON 
	GLB_NT_OP.CD_NT_OP = GLB_NT_OP_ICMS_AJUSTES.CD_NT_OP
	INNER JOIN TBL_ICMS_AJUSTES ON 
	GLB_NT_OP_ICMS_AJUSTES.CD_CTR_AJUSTE = TBL_ICMS_AJUSTES.CD_CTR

	INNER JOIN PRC_FILIAL ON     
    EST_NF_ENT.CD_EMP =  PRC_fILIAL.CD_EMP 
    AND EST_NF_ENT.CD_FILIAL =  PRC_fILIAL.CD_FILIAL
    INNER JOIN GLB_CID ON GLB_CID.CD_CID = PRC_FILIAL.CD_CID
	 
	 LEFT JOIN CTB_APURA_ICMS_AJUSTES_PDV_VD_IT ON  
	 PDV_VD_DEV_EST_PROD_IMP.CD_EMP = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_EMP AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_FILIAL AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_VD = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_VD AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_PROD = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_PROD AND 
     PDV_VD_DEV_EST_PROD_IMP.CD_IT = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_IT
 
    LEFT JOIN CTB_APURA_ICMS_AJUSTES  ON 
	CTB_APURA_ICMS_AJUSTES.CD_EMP = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_EMP 
	AND CTB_APURA_ICMS_AJUSTES.CD_FILIAL = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_FILIAL 
	AND CTB_APURA_ICMS_AJUSTES.CD_CTR = CTB_APURA_ICMS_AJUSTES_PDV_VD_IT.CD_CTR

    WHERE  GLB_NT_OP_ICMS_AJUSTES.TIPO = 2
    AND EST_NF_ENT.DT_ENT > = GLB_NT_OP_ICMS_AJUSTES.DATA_INICIO
    AND GLB_CID.UF = LEFT(TBL_ICMS_AJUSTES.COD_AJUSTE,2)
    AND STS_NF = 0
 



 

